/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.inventory.VacuumTrapMenu;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

public class VacuumTrapBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
MenuProvider,
ISerializableTanks,
IRangedTE {
    static final String DEFENDER_TAG = "pneumaticcraft:defender";
    public static final int MEMORY_ESSENCE_AMOUNT = 100;
    private final SpawnerCoreItem.SpawnerCoreItemHandler inv = new SpawnerCoreItem.SpawnerCoreItemHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inv);
    private final List<Mob> targetEntities = new ArrayList<Mob>();
    private final RangeManager rangeManager = new RangeManager(this, 0x60600060);
    @GuiSynced
    private final SmartSyncTank xpTank = new XPTank();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.xpTank);
    @DescSynced
    private boolean isCoreLoaded;
    @DescSynced
    public Problems problem = Problems.OK;

    public VacuumTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.VACUUM_TRAP.get(), pos, state, PressureTier.TIER_ONE, 10000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.xpTank.tick();
        this.rangeManager.setRange(3 + this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.RANGE.get())));
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isOpen() && this.isCoreLoaded && this.nonNullLevel().f_46441_.nextBoolean()) {
            ClientUtils.emitParticles(this.f_58857_, this.f_58858_, (ParticleOptions)ParticleTypes.f_123760_);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        boolean bl = this.isCoreLoaded = this.inv.getStats() != null;
        if (this.isOpen() && this.isCoreLoaded && this.inv.getStats().getUnusedPercentage() > 0 && this.getPressure() <= this.getMinWorkingPressure()) {
            if ((this.nonNullLevel().m_46467_() & 0xFL) == 0L) {
                this.scanForEntities();
            }
            Vec3 trapVec = Vec3.m_82512_((Vec3i)this.f_58858_);
            double min = this.nonNullLevel().m_6425_(this.f_58858_).m_76152_() == Fluids.f_76193_ ? 2.5 : 1.75;
            for (Mob e : this.targetEntities) {
                if (!e.m_6084_() || e.m_19880_().contains(DEFENDER_TAG)) continue;
                if (e.m_20238_(trapVec) <= min) {
                    this.absorbEntity(e);
                    this.addAir((int)(10.0f * e.m_21223_()));
                    continue;
                }
                e.m_21573_().m_26519_(trapVec.m_7096_(), trapVec.m_7098_(), trapVec.m_7094_(), 1.2);
            }
        }
        this.problem = !this.isCoreLoaded ? Problems.NO_CORE : (this.inv.getStats().getUnusedPercentage() == 0 ? Problems.CORE_FULL : (!this.isOpen() ? Problems.TRAP_CLOSED : Problems.OK));
    }

    private void absorbEntity(Mob e) {
        int toAdd = 1;
        if (this.xpTank.getFluid().getAmount() >= 100) {
            toAdd += e.f_19853_.f_46441_.nextInt(3) + 1;
        }
        if (this.inv.getStats().addAmount(e.m_6095_(), toAdd)) {
            e.m_146870_();
            if (toAdd > 1) {
                this.xpTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            }
            this.inv.getStats().serialize(this.inv.getStackInSlot(0));
            e.f_19853_.m_5594_(null, this.f_58858_, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 2.0f);
            if (this.f_58857_ instanceof ServerLevel) {
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, e.m_20185_(), e.m_20186_() + 0.5, e.m_20189_(), 5, 0.0, 1.0, 0.0, 0.0);
            }
        }
    }

    private void scanForEntities() {
        this.targetEntities.clear();
        this.targetEntities.addAll(this.nonNullLevel().m_6443_(Mob.class, this.rangeManager.getExtents(), this::isApplicable));
    }

    private boolean isApplicable(LivingEntity e) {
        return e.m_6072_() && !(e instanceof DroneEntity) && (!(e instanceof TamableAnimal) || !((TamableAnimal)e).m_21824_()) && !e.m_6095_().m_204039_(PneumaticCraftTags.EntityTypes.VACUUM_TRAP_BLACKLISTED);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidTank getFluidTank() {
        return this.xpTank;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.xpTank);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inv;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == Direction.DOWN || side.m_122434_() == this.getRotation().m_122434_();
    }

    @Override
    public float getMinWorkingPressure() {
        return -0.5f;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new VacuumTrapMenu(windowId, inv, this.m_58899_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inv.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inv.serializeNBT());
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        if (!this.shouldPreserveStateOnBreak()) {
            super.getContentsToDrop(drops);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        if (preserveState) {
            blockEntityTag.m_128365_("Items", (Tag)this.inv.serializeNBT());
        }
    }

    public boolean isOpen() {
        return this.m_58900_().m_60734_() == ModBlocks.VACUUM_TRAP.get() && (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_) != false;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    public AABB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtents() : super.getRenderBoundingBox();
    }

    private class XPTank
    extends SmartSyncTank {
        public XPTank() {
            super(VacuumTrapBlockEntity.this, 16000);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_205067_(PneumaticCraftTags.Fluids.EXPERIENCE);
        }
    }

    public static enum Problems implements ITranslatableEnum
    {
        OK,
        NO_CORE,
        CORE_FULL,
        TRAP_CLOSED;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.vacuum_trap." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMobSpawn(LivingSpawnEvent.SpecialSpawn event) {
            if (!event.isCanceled() && event.getSpawner() != null) {
                event.getEntity().m_20049_(VacuumTrapBlockEntity.DEFENDER_TAG);
            }
        }
    }
}

